import pandas as pd   
import pickle
from decision_company import read_csv_file, logical_and, check_elements_in_list, filter_by_condition

# Load the dataset      
credit_customers = read_csv_file("credit_customers.csv")      
  
# Filter customer segments      
middle_aged_condition = logical_and(credit_customers['age'] > 40, credit_customers['age'] < 59)  
middle_aged_customers = filter_by_condition(credit_customers, middle_aged_condition)  
  
stable_employment_condition = check_elements_in_list(credit_customers['employment'], ['>=7', '4<=X<7'])  
stable_employment_customers = filter_by_condition(credit_customers, stable_employment_condition)  
  
good_credit_history_condition = check_elements_in_list(credit_customers['credit_history'], ['existing paid', 'no credits/all paid', 'all paid'])  
good_credit_history_customers = filter_by_condition(credit_customers, good_credit_history_condition)  
  
print(middle_aged_customers)
pickle.dump(middle_aged_customers,open("./ref_result/middle_aged_customers.pkl","wb"))

print(stable_employment_customers)
pickle.dump(stable_employment_customers,open("./ref_result/stable_employment_customers.pkl","wb"))

print(good_credit_history_customers)
pickle.dump(good_credit_history_customers,open("./ref_result/good_credit_history_customers.pkl","wb"))

  